//go:build unix

package db0605

import (
	"os"
	"path"
	"syscall"
)

// open or create a file and fsync the directory
func createFileSync(file string) (*os.File, error) {
	fp, err := os.OpenFile(file, os.O_RDWR|os.O_CREATE, 0o644)
	if err != nil {
		return nil, err
	}
	if err = syncDir(path.Base(file)); err != nil {
		_ = fp.Close()
		return nil, err
	}
	return fp, err
}

func syncDir(file string) error {
	flags := os.O_RDONLY | syscall.O_DIRECTORY
	dirfd, err := syscall.Open(path.Dir(file), flags, 0o644)
	if err != nil {
		return err
	}
	defer syscall.Close(dirfd)
	return syscall.Fsync(dirfd)
}

func renameSync(src string, dst string) error {
	if err := os.Rename(src, dst); err != nil {
		return err
	}
	return syncDir(dst)
}

// QzBQWVJJOUhU https://trialofcode.org/
